state AssassinSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity, quileg_stream		: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_man_mage.bnk") )
		{
			theSound.SoundLoadBank( "magic_man_mage.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("qu_nml_108.bnk") )
		{
			theSound.SoundLoadBank( "qu_nml_108.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("qu_item_demonic_saddle.bnk") )
		{
			theSound.SoundLoadBank( "qu_item_demonic_saddle.bnk", false );
		}
		
		/*
		if ( parent.spell_name == 'assassin_tornado' )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
				parent.AddTimer('rotate_towards_target', 0.0001, true );
			}
		}
		else
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else*/
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
		
		cast_spells_assassin_curse();
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		if ( animEventName == 'cast_throw' )
		{
			cast_spells_assassin();
		}
		if ( animEventName == 'cast_end' )
		{
			cast_spells_assassin_tornado();
			cast_spells_assassin_curse_act();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_assassin()
	{
		var basePos, pos			: Vector;
		var rot 					: EulerAngles;
		var spikeEnt				: CEntity;
		var PositionLocal			: Vector;
		var PositionGlobal			: Vector;
		var polarAngle, unitAngle 	: float;
		var radius, angle		 	: float;
		
		switch( parent.spell_name )
		{
			case 'assassin_bless':
				{
					//clear_guarding_buffs( false );
				
					duration = 13;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
				
					CustomEffect.effectType = EET_AssassinBless;
					CustomEffect.creator = GetWitcherPlayer();
					CustomEffect.duration = duration;
					GetWitcherPlayer().AddEffectCustom( CustomEffect );
					thePlayer.SoundEvent("fx_rune_activate_axii");
					thePlayer.PlayEffect('mutation_1_quen_power');
					
					FactsAdd("should_reapply_energy_trap_spells",,1);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			default:		
				break;
		}
	}
	
	
	private function cast_spells_assassin_tornado()
	{
		var tornado 	: W3AssassinTornado;
	
		if ( parent.spell_name == 'assassin_tornado' )
		{
			theGame.GetEntitiesByTag('tornado_spells',ents_destroy);
			for( i=0; i<ents_destroy.Size(); i+=1 )
			{
				ents_destroy[i].AddTimer('destroy_tornado',0.0f);
			} 	
			
			parent.templatename = "dlc\magicspellsrev\data\entities\assassin_tornado.w2ent";
		
			duration = 15;
			duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.7 );
		
			//theGame.witcherLog.AddMessage("DURATION  =  " + duration);
			
			position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*6;
		
			position = find_position_spells( position );
		
			tornado = (W3AssassinTornado)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), thePlayer.GetWorldRotation());
			tornado.AddTimer('destroy_tornado', duration );
			tornado.AddTag('tornado_spells');
			tornado.AddTag( 'spells_from_sign' );
			
			Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
		}
	}
	
	
	private function cast_spells_assassin_curse()
	{
		if ( parent.spell_name == 'assassin_curse' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) 
				&& VecDistance(thePlayer.GetWorldPosition(), parent.actor.GetWorldPosition()) <= 5 )
			{
				GetMagicEffectLeft().PlayEffect('assassin_hand_simple');
				GetMagicEffectLeft().StopEffect('assassin_hand_simple');
			}
			else
			{
				thePlayer.SetBehaviorVariable( 'bStopSign', 1.f );
				thePlayer.SetBehaviorVariable( 'axiiResisted', 1.f );
				
				parent.GotoState( 'Vigil_Dreaming' );
			}
		}
	}
	private function cast_spells_assassin_curse_act()
	{
	
		if ( parent.spell_name == 'assassin_curse' )
		{
			duration = MaxF( 4, MinF( 10, GetMagicVigil().get_magic_spellpower() * 6 ) );
			//theGame.witcherLog.AddMessage("DURAION  =  " + duration );
		
			damage_action = new W3DamageAction in this;
			damage_action.Initialize(thePlayer,parent.actor,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
			damage_action.SetProcessBuffsIfNoDamage(true);
			damage_action.AddEffectInfo( EET_SpellsSlowDownAverage, duration ); 
			damage_action.AddEffectInfo( EET_CurseOfAssassin, duration ); 
			damage_action.AddEffectInfo( EET_Stagger ); 
			
			theGame.damageMgr.ProcessAction( damage_action );
			delete damage_action;
			
			parent.actor.SoundEvent('qu_nml_108_distance_wraith');
			
			effect_entity = parent.actor.CreateFXEntityAtPelvis( 'assassin', true );
			effect_entity.DestroyAfter(2);
			
			main_effect = thePlayer.CreateFXEntityAtBone( 'assassin', 'l_hand',true );
			main_effect.PlayEffect( 'assassin_drain', effect_entity );
			main_effect.StopAllEffects();
			main_effect.DestroyAfter(5);
			
			Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
			
		}
		
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}